/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_05;
import java.io.*; import java.util.Calendar; import javax.servlet.http.*;
import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class DominoServlet extends HttpServlet {
	
	/**
	 * Einfaches Servlet Beispiel mit<br>
	 * - Ausgabe diverser Parameter<br>
	 * - Ausgabe der Cookies<br>
	 * - Anzeige des Angemeldeten Benutzers<br>
	 * - Demo einer Notes Session<br>
	 * - Demo einer HttpSession<br>
	 */
	public void doGet(HttpServletRequest req, HttpServletResponse res)
			throws IOException {
		Session session = null;
		PrintWriter out = res.getWriter();
		try {
			NotesThread.sinitThread();
			session = NotesFactory.createSession();
			HttpSession httpSession = req.getSession(true);
			res.setContentType("text/html"); 
			out.println ("<html><head>\n" +
					"<title>Domino Servlet</title>\n<style>\n" +
					"\tbody {font-family:Helvetica,Arial,sans-serif;}\n" +
					"\th1 {color:#FF00FF;}\n</style>\n</head>\n" +
					"<body>\n<h1>Herzlich Willkommen</h1>\n" +
					"\nDies ist ein Domino Servlet\n");
			out.println("<br/>Request Methode = " + req.getMethod());
			out.println("<form action=\"servletalias\" method=\"POST\"><br/>\n");
			out.println("<input type=text name=\"parameter\" value=\"" 
					+ req.getParameter("parameter") + "\"/>" +
					"<input type=\"submit\"/></form>\n");
			out.println("<br/>QueryString: " + req.getQueryString());
			out.println("<br/>Parameter: " + req.getParameter("parameter"));			
			out.println("<br/>Java Version: " + System.getProperty("java.version"));
			out.println("<br/>Java JVM Hersteller: " + System.getProperty("java.vendor"));
			out.println("<br/>Java Installationsverzeichnis: " + System.getProperty("java.home"));
			out.println("<br/>Session isNew: " + httpSession.isNew() + " / " + httpSession.getValue("lastaccess"));
			httpSession.putValue("lastaccess", "Ich war hier: " + Calendar.getInstance().getTime());
			out.println("<br/><b>Domino User: " + session.getUserName() + "</b>");
			out.println("<br/>Init Parameter arg1: " + this.getServletConfig().getInitParameter("arg1"));
			out.println("<br/>Init Parameter arg2: " + this.getServletConfig().getInitParameter("arg2"));
			out.println("<br/>Remote User: " + req.getRemoteUser());
			out.println("<br/>Cookie: " + cookieToString(req));
			out.println ("\n</body>\n</html>\n");
			out.flush();out.close();
		} catch (NotesException e) {
			e.printStackTrace();
		} finally {
			if (session != null) {
				try {
					session.recycle();
				} catch (NotesException e1) {
					e1.printStackTrace();
				}
			}
			NotesThread.stermThread();
		}
	}

	/**
	 * @param req - der HTTPServlet Request<br>
	 * @return - Die gefundenen Cookies als String in der Form<br>
	 * cookie=value;otherCookie=otherValue<br>
	 */
	private String cookieToString(HttpServletRequest req) {
		String cookieString = "";
		Cookie[] cookie = req.getCookies();
		for (int i = 0; cookie != null && i < cookie.length; i++) {
			cookieString += cookie[i].getName()
				+ "="
				+ cookie[i].getValue()
				+ ";";
		}
		return cookieString;
	}

	/**
	 * HTTP Request von POST auf GET umleiten
	 */
	public void doPost(HttpServletRequest req, HttpServletResponse res)
			throws IOException {
		doGet(req, res);
	}

}